/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.DoubleNumericSpinner;
import DE.siemens.ad.logo.dialog.comp.NumberCellEditor;
import DE.siemens.ad.logo.model.AbstractInputSimulationParameter;
import DE.siemens.ad.logo.model.SimulationParameter;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.util.DoubleValueProperties;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SimulationParameterPanel
extends DataInputPanel {
    private LogoDrawing fLogoDrawing;
    private static final int NAME_COLUMN = 0;
    private static final int TYPE_COLUMN = 1;
    private static final int AUTO_RANGE_COLUMN = 3;
    private static final int CURRENT_VALUE_COLUMN = 2;
    private static final int MIN_VALUE_COLUMN = 4;
    private static final int MAX_VALUE_COLUMN = 5;
    protected DefaultTableModel fSimulationParameterTableModel;
    protected JTable fSimulationParameterTable;
    protected JLabel fDescriptionLabel;
    protected Hashtable fSwitchTypeNameDictionary;
    private List fInputBlocks;

    public SimulationParameterPanel(List inputBlocks, LogoDrawing logoDrawing) {
        this.fLogoDrawing = logoDrawing;
        this.fInputBlocks = new ArrayList(inputBlocks.size());
        for (InputBlock inputBlock : inputBlocks) {
            if (inputBlock.getSimulationParameter() == null) continue;
            this.fInputBlocks.add(inputBlock);
        }
        this.fSwitchTypeNameDictionary = new Hashtable(20);
        this.initComponents();
    }

    public String getSwitchModeText(int mode) {
        Object value = this.fSwitchTypeNameDictionary.get(new Integer(mode));
        if (value != null) {
            return (String)value;
        }
        return mode + ": no translation.";
    }

    public String getTitle() {
        return Language.getString("dialog.switch.title", "Function of the input switches");
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.fDescriptionLabel = new JLabel("description");
        this.add((Component)this.fDescriptionLabel, "North");
        Object[] columnNames = new Object[]{"Name", "Typ", "Aktual", "Auto range", "Min", "Max"};
        this.fSimulationParameterTableModel = new SimulationParameterTableModel(columnNames, this.fInputBlocks.size());
        this.fSimulationParameterTable = new JTable(this.fSimulationParameterTableModel);
        this.fSimulationParameterTable.setSelectionMode(0);
        this.add(new JScrollPane(this.fSimulationParameterTable));
        this.fSimulationParameterTable.getColumnModel().getColumn(0).setCellRenderer(new BlockNameCellRenderer());
        this.fSimulationParameterTable.getColumnModel().getColumn(1).setCellRenderer(new SwitchTypeTableCellRenderer());
        JComboBox<Object> comboBox = new JComboBox<Object>();
        comboBox.setRenderer(new SwitchTypeListCellRenderer());
        TableColumn typeColumn = this.fSimulationParameterTable.getColumnModel().getColumn(1);
        typeColumn.setCellEditor(new SwitchTypeTableCellEditor(comboBox));
        TableColumn currentColumn = this.fSimulationParameterTable.getColumnModel().getColumn(2);
        currentColumn.setCellEditor(new NumberCellEditor(new DoubleNumericSpinner()));
        currentColumn.setCellRenderer(new DoubleValueCellRenderer());
        TableColumn minColumn = this.fSimulationParameterTable.getColumnModel().getColumn(4);
        minColumn.setCellEditor(new NumberCellEditor(new DoubleNumericSpinner()));
        minColumn.setCellRenderer(new DoubleValueCellRenderer());
        TableColumn maxColumn = this.fSimulationParameterTable.getColumnModel().getColumn(5);
        maxColumn.setCellEditor(new NumberCellEditor(new DoubleNumericSpinner()));
        maxColumn.setCellRenderer(new DoubleValueCellRenderer());
        TableColumn autoRangeColumn = this.fSimulationParameterTable.getColumnModel().getColumn(3);
        JCheckBox checkBox = new JCheckBox();
        checkBox.setBackground(this.fSimulationParameterTable.getBackground());
        checkBox.setHorizontalAlignment(0);
        autoRangeColumn.setCellEditor(new DefaultCellEditor(checkBox));
        autoRangeColumn.setCellRenderer(new CheckboxTableCellRenderer());
    }

    public void loadFieldContents() {
        Iterator i = this.fInputBlocks.iterator();
        AbstractInputSimulationParameter simulationParameter = null;
        int row = 0;
        while (i.hasNext()) {
            simulationParameter = (AbstractInputSimulationParameter)((InputBlock)i.next()).getSimulationParameter();
            if (simulationParameter == null) continue;
            this.fSimulationParameterTableModel.setValueAt(simulationParameter, row, 0);
            this.fSimulationParameterTableModel.setValueAt(new Integer(simulationParameter.getSwitchMode()), row, 1);
            this.fSimulationParameterTableModel.setValueAt(simulationParameter.getExternAnalogValueProperties(), row, 2);
            this.fSimulationParameterTableModel.setValueAt(simulationParameter.getMinValueProperties(), row, 4);
            this.fSimulationParameterTableModel.setValueAt(simulationParameter.getMaxValueProperties(), row, 5);
            this.fSimulationParameterTableModel.setValueAt(new Boolean(simulationParameter.isAutoMeasurementRange()), row, 3);
            ++row;
        }
    }

    public void setLabels() {
        this.fDescriptionLabel.setText(Language.getString("dialog.switch.title", "Function of the input switches"));
        TableColumnModel columnModel = this.fSimulationParameterTable.getColumnModel();
        columnModel.getColumn(0).setHeaderValue(Language.getString("dialog.switch.name", "Name"));
        columnModel.getColumn(1).setHeaderValue(Language.getString("dialog.switch.type", "Type"));
        columnModel.getColumn(2).setHeaderValue(Language.getString("dialog.switch.currentValue", "Current value"));
        columnModel.getColumn(3).setHeaderValue(Language.getString("dialog.switch.autoRange", "Auto range"));
        columnModel.getColumn(4).setHeaderValue(Language.getString("dialog.switch.minValue", "Min"));
        columnModel.getColumn(5).setHeaderValue(Language.getString("dialog.switch.maxValue", "Max"));
        this.fSwitchTypeNameDictionary.put(new Integer(0), Language.getString("dialog.switch.switch", "Switch"));
        this.fSwitchTypeNameDictionary.put(new Integer(1), Language.getString("dialog.switch.key.opened", "Momentary (normally opened)"));
        this.fSwitchTypeNameDictionary.put(new Integer(8), Language.getString("dialog.switch.key.closed", "Momentary (normally closed)"));
        this.fSwitchTypeNameDictionary.put(new Integer(2), Language.getString("dialog.switch.frequency", "Frequency"));
        this.fSwitchTypeNameDictionary.put(new Integer(4), Language.getString("dialog.switch.analog", "Analogue"));
    }

    public void storeFieldContents() {
        TableCellEditor editor;
        if (this.fSimulationParameterTable.isEditing() && (editor = this.fSimulationParameterTable.getCellEditor()) != null && editor.stopCellEditing()) {
            editor.cancelCellEditing();
        }
        Iterator i = this.fInputBlocks.iterator();
        AbstractInputSimulationParameter simulationParameter = null;
        int row = 0;
        while (i.hasNext()) {
            simulationParameter = (AbstractInputSimulationParameter)((InputBlock)i.next()).getSimulationParameter();
            simulationParameter.setSwitchMode((Integer)this.fSimulationParameterTableModel.getValueAt(row, 1));
            simulationParameter.setExternAnalogValue(((DoubleValueProperties)this.fSimulationParameterTableModel.getValueAt(row, 2)).getCurrentValue());
            simulationParameter.setMinValue(((DoubleValueProperties)this.fSimulationParameterTableModel.getValueAt(row, 4)).getCurrentValue());
            simulationParameter.setMaxValue(((DoubleValueProperties)this.fSimulationParameterTableModel.getValueAt(row, 5)).getCurrentValue());
            simulationParameter.setAutoMeasurementRange((Boolean)this.fSimulationParameterTableModel.getValueAt(row, 3));
            ++row;
        }
        this.fLogoDrawing.setModified(true);
    }

    private class DoubleValueCellRenderer
    extends DefaultTableCellRenderer {
        private DoubleValueCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            this.setEnabled(table.getModel().isCellEditable(row, column));
            this.setHorizontalAlignment(4);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (table.isCellEditable(row, column)) {
                    this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    this.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
            } else {
                this.setBorder(null);
            }
            this.setFont(table.getFont());
            if (value instanceof DoubleValueProperties) {
                DoubleValueProperties dvp = (DoubleValueProperties)value;
                dvp.correctValue();
                this.setText(DecimalFormat.getNumberInstance().format(dvp.getCurrentValue()));
            }
            if (value instanceof Double) {
                double doubleValue = (Double)value;
                this.setText(DecimalFormat.getNumberInstance().format(doubleValue));
            }
            return this;
        }
    }

    private class BlockNameCellRenderer
    extends DefaultTableCellRenderer {
        private BlockNameCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(Color.lightGray);
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            this.setHorizontalAlignment(2);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (table.isCellEditable(row, column)) {
                    this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    this.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
            } else {
                this.setBorder(null);
            }
            if (value instanceof SimulationParameter) {
                this.setText(((SimulationParameter)value).getBlock().getNumberString());
                this.setIcon(Global.getIcon(((SimulationParameter)value).getBlock().getIconName()));
            }
            return this;
        }
    }

    private class NameCellRenderer
    extends DefaultTableCellRenderer {
        private NameCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(Color.lightGray);
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            this.setText(((SimulationParameter)value).getBlock().getNumberString());
            this.setHorizontalAlignment(0);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (table.isCellEditable(row, column)) {
                    this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    this.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
            } else {
                this.setBorder(null);
            }
            return this;
        }
    }

    private class SimulationParameterTableModel
    extends DefaultTableModel {
        public SimulationParameterTableModel(Object[] columnNames, int rowCount) {
            super(columnNames, rowCount);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            int type = (Integer)this.getValueAt(rowIndex, 1);
            boolean autoRange = (Boolean)this.getValueAt(rowIndex, 3);
            if (columnIndex == 0) {
                return false;
            }
            if (!(columnIndex != 2 && columnIndex != 3 || type != 0 && type != 1 && type != 8)) {
                return false;
            }
            return columnIndex != 4 && columnIndex != 5 || !autoRange && type != 0 && type != 1 && type != 8;
        }

        public void setValueAt(Object value, int row, int column) {
            super.setValueAt(value, row, column);
            if (column == 4) {
                double min = ((DoubleValueProperties)value).getCurrentValue();
                ((DoubleValueProperties)this.getValueAt(row, 2)).setMin(min);
                DoubleValueProperties maxValueProperties = (DoubleValueProperties)this.getValueAt(row, 5);
                if (maxValueProperties != null) {
                    maxValueProperties.setMin(min);
                }
            }
            if (column == 5) {
                double max = ((DoubleValueProperties)value).getCurrentValue();
                ((DoubleValueProperties)this.getValueAt(row, 2)).setMax(max);
                DoubleValueProperties minValueProperties = (DoubleValueProperties)this.getValueAt(row, 4);
                if (minValueProperties != null) {
                    minValueProperties.setMax(max);
                }
            }
            SimulationParameterPanel.this.repaint();
        }

        public Class getColumnClass(int index) {
            if (index == 3) {
                return Boolean.class;
            }
            return super.getColumnClass(index);
        }
    }

    public class SwitchTypeListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(SimulationParameterPanel.this.getSwitchModeText((Integer)value));
            return this;
        }
    }

    private class SwitchTypeTableCellRenderer
    extends DefaultTableCellRenderer {
        private SwitchTypeTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            if (value != null) {
                this.setText(SimulationParameterPanel.this.getSwitchModeText((Integer)value));
                if (hasFocus) {
                    this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                    if (table.isCellEditable(row, column)) {
                        this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                        this.setBackground(UIManager.getColor("Table.focusCellBackground"));
                    }
                } else {
                    this.setBorder(null);
                }
            }
            return this;
        }
    }

    private class SwitchTypeTableCellEditor
    extends NumberCellEditor {
        public SwitchTypeTableCellEditor(JComboBox comboBox) {
            super(comboBox);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (comp instanceof JComboBox) {
                AbstractInputSimulationParameter simParam = (AbstractInputSimulationParameter)SimulationParameterPanel.this.fSimulationParameterTableModel.getValueAt(row, 0);
                int[] switchModesInt = simParam.getAvailableSwitchModes();
                Object[] switchModesObj = new Object[switchModesInt.length];
                for (int i = 0; i < switchModesInt.length; ++i) {
                    switchModesObj[i] = new Integer(switchModesInt[i]);
                }
                ((JComboBox)comp).setModel(new DefaultComboBoxModel<Object>(switchModesObj));
            }
            return comp;
        }
    }

    private class CheckboxTableCellRenderer
    implements TableCellRenderer {
        JCheckBox checkBox = new JCheckBox();

        private CheckboxTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.checkBox.setSelected(value.equals(Boolean.TRUE));
            this.checkBox.setEnabled(SimulationParameterPanel.this.fSimulationParameterTableModel.isCellEditable(row, column));
            this.checkBox.setHorizontalAlignment(0);
            this.checkBox.setOpaque(true);
            if (isSelected) {
                this.checkBox.setForeground(table.getSelectionForeground());
                this.checkBox.setBackground(table.getSelectionBackground());
            } else {
                this.checkBox.setForeground(table.getForeground());
                this.checkBox.setBackground(table.getBackground());
            }
            SimulationParameterPanel.this.setFont(table.getFont());
            JPanel borderPanel = new JPanel(new BorderLayout());
            borderPanel.add(this.checkBox);
            borderPanel.setBorder(new LineBorder(Color.green, 2));
            if (hasFocus) {
                borderPanel.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (table.isCellEditable(row, column)) {
                    this.checkBox.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    this.checkBox.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
                this.checkBox.requestFocus();
            } else {
                borderPanel.setBorder(null);
            }
            return borderPanel;
        }
    }
}

